<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Place;
use Illuminate\Http\Request;

class PlaceController extends Controller
{
    public function index()
    {
        $places = Place::all(); // Include count of reviews
        return response()->json($places);

    }

    public function show($id)
    {
        $game = Place::with('reviews')->find($id);

        $placeData = [
            'game' => $game,
        ];

        return response()->json($placeData);
    }
}
