<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Resources\ReviewResources;
use App\Models\Review;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ReviewController extends Controller
{
    public function store(Request $request)
    {
        // Validate incoming review data
        $validatedData = $request->validate([
            'place_id' => 'required|exists:places,id',
            'username' => 'required|string}|min:3',
            'email' => 'required|email',
            'star_rating' => 'required|numeric|min:1|max:5',
            'comments' => 'sometimes|string',
            'location' => 'sometimes|string',
            'image' => 'sometimes|image|max:2048',
        ]);

        if ($request->hasFile('image')) {
            $imagePath = $request->file('image')->store('images', 'public');
            $validatedData['image'] = $imagePath;
        }

        // Create a new review
        $review = Review::create($validatedData);

        return response()->json([
            'data' => ReviewResources::make($review),
            'message' => 'Landmark Review submitted successfully', ], 201);
    }
}
