<?php

use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\PlaceController;
use App\Http\Controllers\API\ReviewController;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
Route::post("register", [AuthController::class, "register"]);
Route::post("login", [AuthController::class, "login"]);

Route::group([
    "middleware" => ["auth:api"]
], function(){

    Route::get("profile", [AuthController::class, "profile"]);
    Route::get("refresh", [AuthController::class, "refreshToken"]);
    Route::get("logout", [AuthController::class, "logout"]);
});


// Route::post('/user-interest', [UserInterestController::class, 'store']);
// Route::middleware('auth:api')->get('/all-user-interest', [UserInterestController::class, 'index']);


Route::get('/place/{id}', [PlaceController::class, 'show']);
Route::get('/places', [PlaceController::class, 'index']);
Route::post('/reviews', [ReviewController::class, 'store']);
